<?php

 
use App\Http\Controllers\HomeController;
 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
 use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
 
Route::get('/',[HomeController::class, 'index'])->name('homepage');
 Route::get('/wa', [HomeController::class, 'wa'])->name('wa');
Route::get('/members/add', [HomeController::class, 'membersAdd'])->name('members-add');
Route::get('/members/edit/{id}', [HomeController::class, 'membersEdit'])->name('members-edit');
Route::post('/members/save', [HomeController::class, 'membersSave'])->name('members-save');
Route::get('/filter/{slug}', [HomeController::class, 'membersFilter'])->name('members-filter');
Route::post('/twilio/webhook', [HomeController::class, 'webhook'])->withoutMiddleware([VerifyCsrfToken::class]);
Route::get('/message', [HomeController::class, 'sendMessages']);
Route::get('/qrcodegen', [HomeController::class, 'testQRCode']);