@extends('layout')
@section('contents')
<div class="row pt-3">
    <div class="col-12"><h3>{{$params['btn']}}</h3></div>
</div>
@if($params['message'] != "")
    <div class="row">
        <div class="col-12" style="color:red; font-weight:400">
            <p>{{$params['message']}}</p>
        </div>
    </div>
@endif
<form name="frm" method="POST" action="{{url('/members/save')}}">
    @csrf
    <input type="hidden" name="mode" value="{{$params['mode']}}"/>
    <input type="hidden" name="id" value="{{$params['id']}}"/>
    
    <div class="row">
        <div class="col-3">
            <label>Salutation</label>
            <select name="salutation" id="salutation" class="form-control">
                @foreach($params['lstSal'] as $row)
                    <?php $sel = $row == $data['salutation'] ? " selected" : ""; ?>
                    <option {{$sel}} value="{{$row}}">{{$row}}</option>
                @endforeach
            </select>
        </div>
        <div class="col-3">
            <label>Name</label>
            <input type="text" name="name" maxlength=200 required class="form-control" value="{{$data['name']}}"/>
        </div>
        <div class="col-3">
            <label>Country</label>
            <select name="country" id="country" class="form-control">
                @foreach($params['lstCountry'] as $row)
                    <?php $sel = $row['phone'] == $data['country'] ? " selected" : ""; ?>
                    <option {{$sel}} value="{{$row['phone']}}">{{$row['name']}} {{$row['phone']}}</option>
                @endforeach
            </select>
        </div>
        <div class="col-3">
            <label>Phone</label>
            <input type="text" name="phone" maxlength=10 required class="form-control" value="{{$data['phone']}}"/>
        </div>
    </div>
    <div class="row pt-3">
        <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">{{$params['btn']}}</button>
        </div>
    </div>
</form>
@endsection